package coreservlets.listeners;

import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** Proces nasuchujcy, ktry ledzi zamwienia
 *  na towary oferowane w ramach oferty dnia.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class DailySpecialWatcher
    implements HttpSessionAttributeListener {
  private static int dailySpecialCount = 0;
  
  /** Jeeli nazwa dodanego atrybutu odpowiada
   *  jednej z wczeniej zapisanych nazw order-attribute-names I
   *  warto atrybutu odpowiada jednej z wartoci
   *  przechowywanych w daily-special-item-names, warto licznika
   *  zamwie na ofert dnia zostaje zwikszona.
   */
  public void attributeAdded(HttpSessionBindingEvent event) {
    checkForSpecials(event, 1);
  }

  /** Jeeli nazwa usunitego atrybutu odpowiada
   *  jednej z wczeniej zapisanych nazw order-attribute-names I
   *  warto atrybutu odpowiada jednej z wartoci
   *  przechowywanych w daily-special-item-names, warto licznika
   *  zamwie na ofert dnia zostaje zmniejszona.
   */
  public void attributeRemoved(HttpSessionBindingEvent event) {
    checkForSpecials(event, -1);
  }

  /** Jeeli nazwa zastpionego atrybutu odpowiada
   *  jednej z wczeniej zapisanych nazw order-attribute-names I
   *  warto atrybutu odpowiada jednej z wartoci
   *  przechowywanych w daily-special-item-names, warto licznika
   *  zamwie na ofert dnia zostaje zmniejszona. Warto zauway,
   *  e wartoci atrybutu jest tutaj warto dotychczasowa
   *  (czyli warto zastpowana), za metoda attributeAdded
   *  bdzie obsugiwa warto now (warto zastpujc).
   */
  public void attributeReplaced(HttpSessionBindingEvent event) {
    checkForSpecials(event, -1);
  }

  /** Sprawdzenie, czy atrybut, ktry zosta wanie dodany
   *  lub zastpiony odpowiada jednej z nazw w order-attribute-names
   *  I warto atrybutu odpowiada jednej z wartoci przechowywanych
   *  w daily-special-item-names. Jeeli tak, warto licznik
   *  zamwie na oferty dnia jest zmieniana (o +1 lub -1).
   */
  private void checkForSpecials(HttpSessionBindingEvent event,
                                int delta) {
    ServletContext context =
      event.getSession().getServletContext();
    ArrayList<String> attributeNames =
      getList(context, "order-attribute-names");
    ArrayList<String> itemNames =
      getList(context, "daily-special-item-names");
    synchronized(attributeNames) {
      for(int i=0; i<attributeNames.size(); i++) {
        String attributeName = attributeNames.get(i);
        for(int j=0; j<itemNames.size(); j++) {
          String itemName = itemNames.get(j);
          if (attributeName.equals(event.getName()) &&
              itemName.equals((String)event.getValue())) {
            dailySpecialCount = dailySpecialCount + delta;
          }
        }
      }
    }
    context.setAttribute("dailySpecialCount",
                         new Integer(dailySpecialCount));
  }

  /** Odczytanie listy order-attribute-names lub
   *  listy daily-special-item-names.
   */
  private ArrayList<String> getList(ServletContext context,
                            String attributeName) {
    ArrayList<String> list =
      (ArrayList)context.getAttribute(attributeName);
    return(list);
  }

  /** Zresetowanie licznika zamwie na oferty dnia.
   *  Operacja jest wykonywana jedynie wwczas,
   *  gdy zmieniony zostanie zakres oferty dnia.
   */
  public static void resetDailySpecialCount() {
    dailySpecialCount = 0;
  }
}
